import os
import json
import sys
import numpy as np
import cv2
import math


EMPTY = 0
NORMAL = 1
JOINT = 2
img = None


def get_strokes(img, joints):
    routes = {}
    for c in joints:
        routes[c], img = route(img, c[0], c[1])

    sim_strokes = []
    for i in range(img.shape[0]):
        for j in range(img.shape[1]):
            if img[i, j] == NORMAL:
                sts, img = route(img, i, j)
                if len(sts) == 1:
                    sim_strokes.append(sts[0][0])
                elif len(sts) == 2:
                    sim_strokes.append(sts[0][0][::-1] + sts[1][0])

    meeti = {}
    mixc_len = 1
    mi = 0
    for c, sts in routes.items():
        if c not in meeti:
            meeti[c] = mi
            mi += 1
        for st, mc in sts:
            if not mc == (-1, -1) and len(st) <= mixc_len:
                if mc in meeti:
                    km = meeti[mc]
                    for mk in meeti:
                        if meeti[mk] == km:
                            meeti[mk] = meeti[c]
                else:
                    meeti[mc] = meeti[c]
                                    
    for i in range(len(joints)):
        for j in range(i + 1, len(joints)):
            if abs(joints[i][0] - joints[j][0]) + abs(joints[i][1] - joints[j][1]) <= 2:
                kj = meeti[joints[j]]
                for k in range(len(joints)):
                    if meeti[joints[k]] == kj:
                        meeti[joints[k]] = meeti[joints[i]]

    return routes, meeti, sim_strokes


def route(img, i, j):
    directions = [
        (-1, 0), (1, 0), (0, -1), (0, 1),
        (-1, -1), (-1, 1), (1, -1), (1, 1)
    ]
    mask = [1, 1, 1, 1, 1, 1, 1, 1]
    img[i, j] = EMPTY
    strokes = []
    starts = []
    for k in range(4):
        if img[i + directions[k][0], j + directions[k][1]] == NORMAL:
            starts.append([i + directions[k][0], j + directions[k][1]])
            img[i + directions[k][0], j + directions[k][1]] = EMPTY
        elif img[i + directions[k][0], j + directions[k][1]] == JOINT:
            if k == 0:
                mask[4], mask[5] = 0, 0
            elif k == 1:
                mask[6], mask[7] = 0, 0
            elif k == 2:
                mask[4], mask[6] = 0, 0
            elif k == 3:
                mask[5], mask[7] = 0, 0
    for k in range(4, 8):
        if mask[k] == 1 and img[i + directions[k][0], j + directions[k][1]] == NORMAL:
            starts.append([i + directions[k][0], j + directions[k][1]])
            img[i + directions[k][0], j + directions[k][1]] = EMPTY
    for start in starts:
        i, j = start[0], start[1]
        stroke, mc = [[i, j]], (-1, -1)
        while True:
            flg = False
            for d in directions[:4]:
                if img[i + d[0], j + d[1]] == NORMAL:
                    i, j = i + d[0], j + d[1]
                    img[i, j] = EMPTY
                    stroke.append([i, j])
                    flg = True
                    break
            if flg:
                continue
            for d in directions[:4]:
                if img[i + d[0], j + d[1]] == JOINT:
                    i, j = i + d[0], j + d[1]
                    mc = (i, j)
                    flg = True
                    break
            if flg:
                break
            for d in directions[4:]:
                if img[i + d[0], j + d[1]] == NORMAL:
                    i, j = i + d[0], j + d[1]
                    img[i, j] = EMPTY
                    stroke.append([i, j])
                    flg = True
                    break
            if flg:
                continue
            for d in directions[4:]:
                if img[i + d[0], j + d[1]] == JOINT:
                    i, j = i + d[0], j + d[1]
                    mc = (i, j)
                    flg = True
                    break
            if flg:
                break
            break
        strokes.append([stroke, mc])
    return strokes, img
